# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 6
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR6_strategy.txt
# LLM Suggested Fallback: C

def benevolent_specter(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    if len(my_history) == 1:
        return "C"
    
    # Analyze opponent's code for static strategies
    always_defect = "return 'D'" in opponent_program_code.replace(" ", "")
    always_cooperate = "return 'C'" in opponent_program_code.replace(" ", "")
    
    if always_defect:
        return "D"
    if always_cooperate and len(my_history) > 2:
        return "D"
    
    # Mid-Game (Rounds 3-7)
    if len(my_history) < 7:
        coop_count = opp_history.count("C")
        defect_count = len(opp_history) - coop_count
        
        if coop_count >= defect_count:
            return "C"
        else:
            if opp_history[-1] == "D":
                return "D" if random.random() < 0.8 else "C"
            else:
                return "C"
    
    # End-Game (Rounds 8-10)
    coop_count = opp_history.count("C")
    defect_count = len(opp_history) - coop_count
    
    if coop_count >= defect_count:
        return "C"
    else:
        return "D"